% MATLAB code: Example 11.1
% File: Inv_Stat.m
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Invertibility, 500 observations for effective use

psi = [0.2, -0.1, 0.4, -0.3; 0.1, 0.3,-0.3 , 0.4]; % psi^{11} matrix

mur     = [0, 0 ];
%sigmar = [2, 0.5; 0.5, 2];   % Sigma_{\epsilon}
muy     = [0, 0];
sigmar  = [1, 0; 0, 1];
nr      = 2000;

a(1,1) =  0.2; % matrix A
a(1,2) =  0.3;
a(2,1) =  0.1;
a(2,2) = -0.5;

b(1,1) =  0.2; % matrix C_{1}
b(1,2) = -0.1;
b(1,3) =  0.4;
b(1,4) = -0.3;
b(2,1) =  0.1; 
b(2,2) =  0.3; 
b(2,3) = -0.3;
b(2,4) =  0.4;

for u=1:1000  % big loop
  eps    = mvnrnd(mur,sigmar,nr); 
  r      = eps';
  y(1,1) = 0;
  y(2,1) = 0;
  y(1,2) = 0;
  y(2,2) = 0;

  for i=3:nr
    y(1,i) = a(1,1)*y(1,i-2)+a(1,2)*y(2,i-2) + 0.5*r(1,i) + ...
             (b(1,1)*y(1,i-1)+b(1,3)*y(2,i-1))*r(1,i-1) + ...
             (b(1,2)*y(1,i-1)+b(1,4)*y(2,i-1))*r(2,i-1);
        
    y(2,i) = a(2,1)*y(1,i-2)+a(2,2)*y(2,i-2) + 0.6*r(2,i) + ...
             (b(2,1)*y(1,i-1)+b(2,3)*y(2,i-1))*r(1,i-1) + ...
             (b(2,2)*y(1,i-1)+b(2,4)*y(2,i-1))*r(2,i-1);       
  end

  sxxt = 0;
  for it=1501:2000
      xxt(it) = 0;
      for i=1:2
          xxt(it) = xxt(it)+y(i,it)*y(i,it);
      end
      sxxt=sxxt+xxt(it);
  end
  sxxt = sxxt/500;
  sqs  = sqrt(sxxt);

  total(u) = sqs*norm(psi);

end  % end big loop u=1:1000

datastats(total')

ytime = y';
ytime = ytime(1501:2000,:);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Stationarity
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
A   = [0.2, 0.3; 0, -0.5];   

S11 = [0.2, -0.1; 0.4, -0.3];  
S21 = [0, 0.3; -0.25, 0.4];

%sigmar = [1, 0; 0, 1];        % covariance matrix
sigmar  = [2, 0.5; 0.5, 2];

prod11  = kron(S11,S11)*sigmar(1,1);
prod21  = kron(S21,S11)*sigmar(2,1);
prod12  = kron(S11,S21)*sigmar(1,2);
prod22  = kron(S21,S21)*sigmar(2,2);

prodA      = kron(A,A);
totalstat2 = prod11+prod21+prod12+prod22;
totalstat  = prodA + totalstat2;

rho = max(abs(eig(totalstat)));  % spectral radius

